/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1541;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import libsidplay.components.c1541.D64;
import libsidplay.components.c1541.G64;
import libsidplay.components.c1541.GCR;
import libsidplay.components.c1541.IExtendImageListener;
import libsidplay.components.c1541.NIB;

public abstract class DiskImage {
    public static final int DIR_TRACK_1541 = 18;
    public static final int MIN_TRACKS_1541 = 35;
    protected static final int EXT_TRACKS_1541 = 40;
    protected static final int MAX_TRACKS_1541 = 42;
    protected static final int[] RAW_TRACK_SIZE = new int[]{6250, 6666, 7142, 7692};
    protected static final int[] SPEED_MAP_1541 = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected int[] trackSize = new int[70];
    protected RandomAccessFile fd;
    protected String fileName;
    protected boolean readOnly;
    protected int tracks;
    protected GCR gcr;
    protected IExtendImageListener extendImageListener;
    private static final int MAX_SECTORS_PER_TRACK = 30;
    public static final int MAX_OVERALL_SECTORS = 1260;

    protected DiskImage(GCR gcr, String fileName, RandomAccessFile fd, boolean readOnly) {
        this.gcr = gcr;
        this.fileName = fileName;
        this.fd = fd;
        this.readOnly = readOnly;
    }

    public static final DiskImage attach(GCR gcr, File file) throws IOException {
        assert (file != null);
        boolean readOnly = !file.canWrite();
        RandomAccessFile fd = new RandomAccessFile(file, file.canWrite() ? "rw" : "r");
        byte[] header = new byte[Math.max("GCR-1541".length(), "MNIB-1541-RAW".length())];
        fd.readFully(header, 0, header.length);
        fd.seek(0L);
        String headerString = new String(header, "ISO-8859-1");
        DiskImage image = headerString.startsWith("GCR-1541") ? new G64(gcr, file.getName(), fd, readOnly) : (headerString.startsWith("MNIB-1541-RAW") ? new NIB(gcr, file.getName(), fd, readOnly) : new D64(gcr, file.getName(), fd, readOnly));
        ((DiskImage)image).attach();
        return image;
    }

    protected abstract void attach() throws IOException;

    public final void detach() throws IOException {
        this.fd.close();
    }

    public final void setExtendImagePolicy(IExtendImageListener listener) {
        this.extendImageListener = listener;
    }

    public abstract void gcrDataWriteback(int var1) throws IOException;

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean getDiskSector(int track, int sector, byte[] currSector) {
        if (track < 1 || track > this.tracks) {
            return false;
        }
        this.gcr.setHalfTrack(track << 1, this.trackSize[track - 1], this.trackSize[track - 1]);
        int gcrDataPos = this.gcr.findSectorHeader(track, sector, this.trackSize[track - 1]);
        if (gcrDataPos != -1) {
            if ((gcrDataPos = this.gcr.findSectorData(gcrDataPos, this.trackSize[track - 1])) == -1) {
                System.err.println(String.format("Could not find data sync of T:%d S:%d.", track, sector));
                return false;
            }
            this.gcr.convertGCRToSector(currSector, gcrDataPos, this.trackSize[track - 1]);
            if (currSector[0] != 7) {
                System.err.println(String.format("Could not find data block id of T:%d S:%d.", track, sector));
                return false;
            }
            return true;
        }
        System.err.println(String.format("Could not find header of T:%d S:%d.", track, sector));
        return false;
    }

    public final boolean save(File file, byte startTrack, byte startSector) throws IOException {
        try (DataOutputStream dout = new DataOutputStream(new FileOutputStream(file));){
            byte[] currSector = new byte[260];
            int[] arrCyclicAccessInfo = new int[1260];
            for (int i = 0; i < arrCyclicAccessInfo.length; ++i) {
                arrCyclicAccessInfo[i] = 0;
            }
            byte nextTrack = startTrack;
            byte nextSector = startSector;
            while (true) {
                boolean bl;
                if (!this.getDiskSector(nextTrack, nextSector, currSector)) {
                    bl = false;
                    return bl;
                }
                int offset = nextTrack * 30 + nextSector;
                if (arrCyclicAccessInfo[offset] != 0) {
                    bl = false;
                    return bl;
                }
                int n = offset;
                arrCyclicAccessInfo[n] = arrCyclicAccessInfo[n] + 1;
                if (currSector[1] == 0) {
                    dout.write(currSector, 3, 254);
                    bl = true;
                    return bl;
                }
                dout.write(currSector, 3, 254);
                nextTrack = currSector[1];
                nextSector = currSector[2];
            }
        }
    }
}

